<?php
//custom css -
$stylesheet = array(PATH_SYSTEM  . 'resources/css/cropper.min.css');

include PATH_VIEW . '/layout/header.tpl';
?>

<div id="ajaxArea">
    <div class="container bg-body-tertiary p-3">

        <div class="row">
            <div class="col-md-12">
                <section id="column1" class="mb-4">

                    <section id="breadcrumb" class="border-bottom mb-4">
                        <?php include PATH_VIEW . '/layout/breadcrumb.tpl' ?>
                    </section>

                    <div class="row">

                        <div class="col-md-3 mb-3">

                            <div class="card mb-3">
                                <div class="p-3 text-center">
                                    <div class="mb-3">
                                        <img class="rounded-circle mb-2 avatar-user" style="height:80px" src="<?php echo PATH_SYSTEM; ?>public/avatar/<?php echo $client->avatar; ?>" alt="<?php echo $client->full_name; ?>">
                                        <h4 class="mb-0 name-user"><?php echo $client->full_name; ?></h4>
                                    </div>

                                    <div class="d-flex justify-content-center">
                                        <span class="me-5"><?php echo $_LANG['rank']; ?> <span class="h6 d-block" id="rank_value">...</span></span>
                                        <span><?php echo $_LANG['points']; ?> <span class="h6 d-block" id="points_value">...</span></span>
                                    </div>

                                </div>
                            </div>

                            <ul class="nav nav-pills card p-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?php echo (empty($page2)) ? 'active' : ''; ?>" id="tab-chat" data-bs-toggle="pill" data-bs-target="#chattab" type="button" role="tab" aria-controls="tab-chat" aria-selected="true"><?php echo $_LANG['chat']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?php echo ($page2 == 'edit-profile') ? 'active' : ''; ?>" id="tab-profile" data-bs-toggle="pill" data-bs-target="#profile" type="button" role="tab" aria-controls="tab-profile" aria-selected="true"><?php echo $_LANG['edit_profile']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?php echo ($page2 == 'edit-pass') ? 'active' : ''; ?>" id="tab-password" data-bs-toggle="pill" data-bs-target="#password" type="button" role="tab" aria-controls="tab-password" aria-selected="false"><?php echo $_LANG['change_password']; ?></a>
                                </li>
                            </ul>

                        </div>

                        <div class="col-md-9 mb-3">
                            <div class="tab-content card" id="v-pills-tabContent">

                                <div class="tab-pane fade <?php echo (empty($page2)) ? 'show active' : ''; ?>" id="chattab" role="tabpanel" aria-labelledby="tab-chat">
                                    <div class="card-body">

                                        <div class="row">
                                            <?php
                                            $widget = (object) ['col' => 12];
                                            include PATH_VIEW . '/widgets/chat.tpl';
                                            ?>
                                        </div>

                                    </div>
                                </div>

                                <div class="tab-pane fade <?php echo ($page2 == 'edit-profile') ? 'show active' : ''; ?>" id="profile" role="tabpanel" aria-labelledby="tab-profile">
                                    <div class="card-body">
                                        <h4 class="title-post mb-4"><?php echo $_LANG['edit_profile']; ?></h4>
                                        <form id="userEditProfile" class="no-ajaxy" enctype="multipart/form-data" method="post">
                                            <input type="hidden" name="action" value="editProfile">

                                            <div class="mb-3 text-center">
                                                <img class="img-thumbnail img-view-result mb-1 avatar-user" id="crop-instance-profile" src="<?php echo PATH_SYSTEM . "public/avatar/" . $client->avatar; ?>" alt="image">

                                                <div class="input-file">
                                                    <input data-instance="profile" data-imgw="240" data-imgh="240" data-newmodal="false" type="file" class="form-control d-none crop-image-modal" id="image_file" name="image_file" accept=".gif,.png,.jpeg,.jpg">

                                                    <label for="image_file" class="btn btn-primary btn-sm" style="width:200px;">
                                                        <?php echo $_LANG['upload_photo']; ?>
                                                    </label>
                                                </div>
                                                <input type="hidden" id="x" name="x" />
                                                <input type="hidden" id="y" name="y" />
                                                <input type="hidden" id="w" name="w" />
                                                <input type="hidden" id="h" name="h" />
                                            </div>

                                            <div class="form-floating mb-3">
                                                <input type="text" class="form-control" id="edit_full_name" placeholder="<?php echo $_LANG['full_name']; ?>" name="full_name" value="<?php echo $client->full_name; ?>" required="" maxlength="40">
                                                <label for="edit_full_name"><?php echo $_LANG['full_name']; ?></label>
                                            </div>

                                            <div class="form-floating mb-3">
                                                <input type="text" class="form-control" value="<?php echo $client->username; ?>" disabled="">
                                                <label><?php echo $_LANG['user']; ?></label>
                                            </div>

                                            <div class="form-floating mb-3">
                                                <input type="text" class="form-control" value="<?php echo $client->email; ?>" disabled="">
                                                <label><?php echo $_LANG['email']; ?></label>
                                            </div>

                                            <div class="mb-3 text-center">
                                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['profile_save']; ?></button>
                                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                                </button>
                                                <span id="res-message" class="d-block mt-3"></span>
                                            </div>

                                        </form>
                                    </div>
                                </div>

                                <div class="tab-pane fade <?php echo ($page2 == 'edit-pass') ? 'show active' : ''; ?>" id="password" role="tabpanel" aria-labelledby="tab-password">
                                    <div class="card-body">
                                        <h4 class="title-post mb-4"><?php echo $_LANG['change_password']; ?></h4>
                                        <form id="userEditPass" class="no-ajaxy" method="post">
                                            <input type="hidden" name="action" value="editPassword">
                                            <div class="form-floating mb-3">
                                                <input type="password" class="form-control" id="new_password" placeholder="<?php echo $_LANG['new_password']; ?>" name="new_password" required="" minlength="8">
                                                <label for="new_password"><?php echo $_LANG['new_password']; ?></label>
                                            </div>

                                            <div class="form-floating mb-3">
                                                <input type="password" class="form-control" id="confirm_password" placeholder="<?php echo $_LANG['new_repeat_password']; ?>" name="confirm_password" required="" minlength="8">
                                                <label for="confirm_password"><?php echo $_LANG['new_repeat_password']; ?></label>
                                            </div>

                                            <div class="mb-3 text-center">
                                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['change_password']; ?></button>
                                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                                </button>
                                                <span id="res-message" class="d-block mt-3"></span>
                                            </div>

                                        </form>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </section>
            </div>

        </div>

    </div>

    <div class="modal fade" id="modal-crop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modal-crop" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <span class="modal-title fs-5 w-100"><?php echo $_LANG['edit_imagem']; ?></span>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="img-container img-view">
                        <img id="image" src="#" alt="crop">
                    </div>
                </div>
                <span id="cropclick" value="0"></span>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $_LANG['cancel']; ?></button>
                    <button type="button" class="btn btn-primary" id="crop"><?php echo $_LANG['save']; ?></button>
                </div>
            </div>
        </div>
    </div>

</div>

<?php
$javascript = array(PATH_SYSTEM  . 'resources/js/cropper.min.js');

include PATH_VIEW . '/layout/footer.tpl';
?>
